package gov.va.med.mhv.rxrefill.data.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

import org.hibernate.annotations.Type;

@Entity
@Table(name = "RX_TRACKING")
public class RxTracking implements Serializable {

	private static final long serialVersionUID = -4959882821766779165L;

	@Id
	@Column(name = "RX_TRACKING_ID", nullable = true)
	@GeneratedValue(strategy = GenerationType.AUTO)
	private Long id;

	@Column(name = "OPLOCK")
	private Integer oplock = 1;

	@Column(name = "STATION_NUMBER")
	private String stationNumber;

	@Column(name = "RX_NUMBER", insertable = false, updatable = false)
	private String rxNumber;

	@Column(name = "CARRIER")
	private String carrier;
	
	@Column(name = "TRACKING_NUMBER")
	private String trackingNumber;
	
	@Column(name = "COMPLETE_DATE_TIME")
	@Temporal(TemporalType.TIMESTAMP)
	private Date completeDateTime;
	
	@Column(name = "DIVISION_PHONE")
	private String divisionPhone;
	
	@Column(name = "NDC")
	private String ndc;
	
	@Column(name = "DATE_LOADED")
	@Temporal(TemporalType.TIMESTAMP)
	private Date dateLoaded;


	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Integer getOplock() {
		return oplock;
	}

	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}

	public String getStationNumber() {
		return stationNumber;
	}

	public void setStationNumber(String stationNumber) {
		this.stationNumber = stationNumber;
	}

	public String getRxNumber() {
		return rxNumber;
	}

	public void setRxNumber(String rxNumber) {
		this.rxNumber = rxNumber;
	}

	public String getCarrier() {
		return carrier;
	}

	public void setCarrier(String carrier) {
		this.carrier = carrier;
	}

	public String getTrackingNumber() {
		return trackingNumber;
	}

	public void setTrackingNumber(String trackingNumber) {
		this.trackingNumber = trackingNumber;
	}

	public Date getCompleteDateTime() {
		return completeDateTime;
	}

	public void setCompleteDateTime(Date completeDateTime) {
		this.completeDateTime = completeDateTime;
	}

	public String getDivisionPhone() {
		return divisionPhone;
	}

	public void setDivisionPhone(String divisionPhone) {
		this.divisionPhone = divisionPhone;
	}

	public String getNdc() {
		return ndc;
	}

	public void setNdc(String ndc) {
		this.ndc = ndc;
	}

	public Date getDateLoaded() {
		return dateLoaded;
	}

	public void setDateLoaded(Date dateLoaded) {
		this.dateLoaded = dateLoaded;
	}

}
